// content_script.js
(function() {
  // Tránh inject nhiều lần khi SPA thay đổi route
  if (window.__zalo_photo_quick_open_installed) return;
  window.__zalo_photo_quick_open_installed = true;
  
  // Hàm chính lắng nghe phím
  document.addEventListener('keydown', function(event) {
      
      // --- ĐIỀU KIỆN HỖ TRỢ ĐA NỀN TẢNG ---
      const isQKey = (event.key === 'q' || event.key === 'Q');
      const isModifierKeyOnly = !event.shiftKey && !event.altKey;

      // Command + Q trên macOS
      const isCommandQ = event.metaKey && isModifierKeyOnly && isQKey;
      
      // Ctrl + Q trên Windows/Linux
      const isCtrlQ = event.ctrlKey && isModifierKeyOnly && isQKey;
      
      // Kích hoạt nếu là Command+Q (Mac) hoặc Ctrl+Q (Win/Linux)
      if (isCommandQ || isCtrlQ) {
          
          // Ngăn chặn hành vi mặc định của trình duyệt (ví dụ: đóng tab)
          try { event.preventDefault(); } catch (e) {}
          
          // Chọn thẻ div có thuộc tính icon với giá trị 'Photo_24_Line'
          var div = document.querySelector('div[icon="Photo_24_Line"]');
          
          // Nếu không tìm thấy ngay (do render chậm), thử tìm lại vài lần trong vòng 500ms
          if (div) {
            div.click();
          } else {
            // thử tìm lại trong 3 lần, mỗi lần cách 150ms
            let attempts = 0;
            const maxAttempts = 3;
            const interval = setInterval(function() {
              attempts++;
              div = document.querySelector('div[icon="Photo_24_Line"]');
              if (div) {
                div.click();
                clearInterval(interval);
              } else if (attempts >= maxAttempts) {
                console.log("Không tìm thấy thẻ div với icon là 'Photo_24_Line'.");
                clearInterval(interval);
              }
            }, 150);
          }
      }
  }, false);
  
  // Nếu DOM có thay đổi (SPA), giữ behavior ổn định: không cần rebind vì flag đã ngăn duplicate.
})();